@extends('layouts.admin')

@section('title', isset($coupon) ? 'Edit Coupon' : 'Create Coupon')

@section('content')
<div class="dashboard-container">
    <div class="dashboard-header">
        <div class="d-flex justify-content-between align-items-center">
            <h1>{{ isset($coupon) ? 'Edit Coupon' : 'Create Coupon' }}</h1>
            <a href="{{ route('admin.coupons.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Back to Coupons
            </a>
        </div>
        <p>{{ isset($coupon) ? 'Update this coupon\'s details' : 'Create a new discount coupon' }}</p>
    </div>

    <div class="dashboard-card dashboard-card-full">
        <div class="dashboard-card-header">
            <h3>Coupon Details</h3>
        </div>
        <div class="dashboard-card-body">
            <form action="{{ isset($coupon) ? route('admin.coupons.update', $coupon) : route('admin.coupons.store') }}" method="POST">
                @csrf
                @if(isset($coupon))
                    @method('PUT')
                @endif

                <div class="form-group">
                    <label for="code">Code</label>
                    <div class="d-flex align-items-center ml-auto">
                        <input type="text" name="code" id="code" class="form-control @error('code') has-error @enderror" value="{{ old('code', $coupon->code ?? '') }}" required>
                        <button type="button" class="btn btn-secondary" id="generateCodeBtn" title="Generate Code">
                            <i class="fas fa-magic"></i> Generate
                        </button>
                    </div>
                    @error('code')<div class="error-message">{{ $message }}</div>@enderror
                </div>

                <div class="form-group">
                    <label for="type">Type</label>
                    <select name="type" id="type" class="form-control @error('type') has-error @enderror" required>
                        <option value="percentage" {{ old('type', $coupon->type ?? '') == 'percentage' ? 'selected' : '' }}>Percentage</option>
                        <option value="fixed" {{ old('type', $coupon->type ?? '') == 'fixed' ? 'selected' : '' }}>Fixed Amount</option>
                    </select>
                    @error('type')<div class="error-message">{{ $message }}</div>@enderror
                </div>

                <div class="form-group">
                    <label for="value">Value</label>
                    <input type="number" name="value" id="value" step="0.01" class="form-control @error('value') has-error @enderror" value="{{ old('value', $coupon->value ?? '') }}" required>
                    @error('value')<div class="error-message">{{ $message }}</div>@enderror
                </div>

                <div class="form-group">
                    <label for="max_uses">Max Uses</label>
                    <input type="number" name="max_uses" id="max_uses" class="form-control @error('max_uses') has-error @enderror" value="{{ old('max_uses', $coupon->max_uses ?? '') }}">
                    @error('max_uses')<div class="error-message">{{ $message }}</div>@enderror
                </div>

                <div class="form-group">
                    <label for="starts_at">Starts At</label>
                    <input type="datetime-local" name="starts_at" id="starts_at" class="form-control @error('starts_at') has-error @enderror" value="{{ old('starts_at', isset($coupon->starts_at) ? $coupon->starts_at->format('Y-m-d\TH:i') : '') }}">
                    @error('starts_at')<div class="error-message">{{ $message }}</div>@enderror
                </div>

                <div class="form-group">
                    <label for="expires_at">Expires At</label>
                    <input type="datetime-local" name="expires_at" id="expires_at" class="form-control @error('expires_at') has-error @enderror" value="{{ old('expires_at', isset($coupon->expires_at) ? $coupon->expires_at->format('Y-m-d\TH:i') : '') }}">
                    @error('expires_at')<div class="error-message">{{ $message }}</div>@enderror
                </div>

                <div class="form-group">
                    <label class="form-check">
                        <input type="checkbox" name="is_active" value="1" {{ old('is_active', $coupon->is_active ?? false) ? 'checked' : '' }}> Active
                    </label>
                </div>

                <div class="form-group d-flex">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i> {{ isset($coupon) ? 'Update Coupon' : 'Create Coupon' }}
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function () {
        document.getElementById('generateCodeBtn').addEventListener('click', function () {
            const codeInput = document.getElementById('code');
            const charset = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
            let code = '';
            for (let i = 0; i < 10; i++) {
                code += charset.charAt(Math.floor(Math.random() * charset.length));
            }
            codeInput.value = code;
        });
    });
</script>
@endpush